/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.client.render.custom;

import com.dfdyz.epicacg.client.render.pipeline.PostEffectPipelines;
import com.dfdyz.epicacg.client.render.pipeline.PostParticleRenderType;
import com.dfdyz.epicacg.client.render.targets.TargetManager;
import com.dfdyz.epicacg.registry.PostEffects;
import com.dfdyz.epicacg.utils.RenderUtils;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class SpaceBrokenRenderType
extends PostParticleRenderType {
    final int layer;
    final int vertex;
    static final PostEffectPipelines.Pipeline ppl1 = new Pipeline(new ResourceLocation("epicacg", "space_broken_0"), 10);
    static final PostEffectPipelines.Pipeline ppl2 = new Pipeline(new ResourceLocation("epicacg", "space_broken_1"), 11);

    public SpaceBrokenRenderType(ResourceLocation name, ResourceLocation texture, int layer, int vertexCount) {
        super(name, texture);
        this.layer = layer;
        this.vertex = vertexCount;
    }

    public SpaceBrokenRenderType(ResourceLocation name, int layer) {
        super(name, RenderUtils.GetTexture("particle/sparks"));
        this.layer = layer;
        this.vertex = 3;
    }

    @Override
    public void setupBufferBuilder(BufferBuilder bufferBuilder) {
        bufferBuilder.m_166779_(this.vertex == 3 ? VertexFormat.Mode.TRIANGLES : VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
    }

    @Override
    public PostEffectPipelines.Pipeline getPipeline() {
        return this.layer == 0 ? ppl1 : ppl2;
    }

    public static class Pipeline
    extends PostEffectPipelines.Pipeline {
        private ResourceLocation space_broken_mask;
        private static ResourceLocation tmpTarget = new ResourceLocation("epicacg", "space_broken_tmp");

        public Pipeline(ResourceLocation name, int priority) {
            super(name);
            this.space_broken_mask = new ResourceLocation("epicacg", "space_broken_mask_" + this.priority);
            this.priority = priority;
        }

        @Override
        public void suspend() {
            if (PostEffectPipelines.isActive()) {
                this.bufferTarget.m_83970_();
                this.bufferTarget.m_83963_();
                RenderTarget rt = PostEffectPipelines.getSource();
                rt.m_83947_(false);
            } else {
                PostEffectPipelines.getSource().m_83947_(false);
            }
        }

        void handlePasses(RenderTarget src) {
            RenderTarget tmp = TargetManager.getTarget(tmpTarget);
            RenderTarget main = Minecraft.m_91087_().m_91385_();
            PostEffects.space_broken.process(main, src, tmp);
            PostEffects.blit.process(tmp, main);
        }

        @Override
        public void PostEffectHandler() {
            RenderTarget target = TargetManager.getTarget(this.space_broken_mask);
            this.handlePasses(this.bufferTarget);
        }
    }
}

